/* program to calculate the rise and descent rate of a balloon
    from APRS.fi telemetry files.

    John Nordlie
    November, 2017
*/

#include<stdio.h>
#include<stdlib.h>
#include<string.h>

int main() {

char instring[255], workstring[255], *strptr;
int hours, minutes, seconds, altitude = 0, time = 0, old_time = 0, delta_time, old_alt = 0, delta_alt;
float ascent;

/* print file header */
printf("Time (seconds since midnight), altitude (feet MSL), ascent rate (feet/minute)\n");

while (!feof(stdin)) {
	
	/* get a string from the input */
	fgets(instring, sizeof(instring), stdin);

	/* parse out the time */
	workstring[0] = instring[11];
	workstring[1] = instring[12];
	workstring[2] = (char)NULL;
	hours = atoi(workstring);

	workstring[0] = instring[14];
	workstring[1] = instring[15];
	workstring[2] = (char)NULL;
	minutes = atoi(workstring);

	workstring[0] = instring[17];
	workstring[1] = instring[18];
	workstring[2] = (char)NULL;
	seconds = atoi(workstring);

	/* look for the altitude marker */
	strptr = strstr(instring, "A=");
	if (strptr == NULL)
		continue;

	/* decode the altitude */
	workstring[0] = strptr[2];
	workstring[1] = strptr[3];
	workstring[2] = strptr[4];
	workstring[3] = strptr[5];
	workstring[4] = strptr[6];
	workstring[5] = strptr[7];
	workstring[6] = (char)NULL;
	altitude = atoi(workstring);


	/* calculate new time */
	old_time = time;
	time = (hours * 3600) + (minutes * 60) + seconds;
	delta_time = time - old_time;

	/* calculate change in altitude since last data */
	delta_alt = altitude - old_alt;
	old_alt = altitude;

	/* calculate ascent rate per minute */
	if (delta_time == 0)
		continue;

	ascent = (float)delta_alt / ((float)delta_time / 60.0);

	/* print out results, time vs. altitude vs. ascent rate */
	printf("%d, %d, %f\n", time, altitude, ascent);

} /* end while */

} /* end main */
