/**********************************************************\
 * (SDSL2) A standalone utility to generate a sphere      * 
 * model in SDSL format.                                  *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define pi 3.141592654

#define RADIUS 1.0
#define DIVS   15
#define TOLER  0.01

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

float vertices[5000][3];
int nVertices=0;
int triangles[5000][3];
int nTriangles=0;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

float module(float f) { if(f>0) return(f); else return(-f); }

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

void addTriangle(int v1, int v2, int v3)
{
 triangles[nTriangles][0]=v1; triangles[nTriangles][1]=v2; triangles[nTriangles][2]=v3;
 nTriangles++;
} 

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

int addVertex(float x, float y, float z)
{
 int i;

 for(i=0;i<nVertices;i++)
  if((module(x-vertices[i][0])<TOLER)&&
     (module(y-vertices[i][1])<TOLER)&&
     (module(z-vertices[i][2])<TOLER)) return(i);

 vertices[nVertices][0]=x; vertices[nVertices][1]=y; vertices[nVertices][2]=z;
 return(nVertices++);
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

main(int no,char **o)
{
 int i,j,nj;
 float y1,y2,rad1,rad2,x11,x12,x21,x22,z11,z12,z21,z22;

 for(i=0;i<DIVS;i++)
 {
  y1=RADIUS*cos(((pi)*i)/(DIVS));
  y2=RADIUS*cos(((pi)*(i+1))/(DIVS));
  rad1=RADIUS*sin(((pi)*i)/(DIVS));
  rad2=RADIUS*sin(((pi)*(i+1))/(DIVS));

  for(j=0;j<DIVS*2;j++)
  {
   if(j<DIVS*2-1) nj=j+1; else nj=0;
   x11=rad1*cos((2*pi*j)/(DIVS*2));
   z11=rad1*sin((2*pi*j)/(DIVS*2));
   x12=rad1*cos((2*pi*nj)/(DIVS*2));
   z12=rad1*sin((2*pi*nj)/(DIVS*2));

   x21=rad2*cos((2*pi*j)/(DIVS*2));
   z21=rad2*sin((2*pi*j)/(DIVS*2));
   x22=rad2*cos((2*pi*nj)/(DIVS*2));
   z22=rad2*sin((2*pi*nj)/(DIVS*2));
   
   if(i==0)
   {
    addTriangle(addVertex(x22,y2,z22),
                addVertex(x21,y2,z21),
                addVertex(x11,y1,z11));
   }
   else if(i==DIVS-1)
   {
    addTriangle(addVertex(x11,y1,z11),
                addVertex(x12,y1,z12),
                addVertex(x21,y2,z21));
   }
   else
   {
    addTriangle(addVertex(x22,y2,z22),
                addVertex(x21,y2,z21),
                addVertex(x11,y1,z11));

    addTriangle(addVertex(x12,y1,z12),
                addVertex(x22,y2,z22),
                addVertex(x11,y1,z11));
   }
  }
 }

 printf("AMBIENT 0.2 0.2 0.2\n");
 printf("DIFFUSE  0.0 0.9 0.0\n");
 printf("SPECULAR 0.0 0.9 0.0\n");
 printf("SHININESS 128\n");

 printf("VERTICES %d\n",nVertices);
 for(i=0;i<nVertices;i++)
  printf("%f %f %f\n",vertices[i][0],vertices[i][1],vertices[i][2]);

 printf("TRIANGLES %d\n",nTriangles);
 for(i=0;i<nTriangles;i++)
  printf("%d %d %d\n",triangles[i][0],triangles[i][1],triangles[i][2]);

}

/**********************************************************/
