/**********************************************************\
 * (SDSL2) A standalone utility to generate a plane model *
 * in SDSL format.                                        *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <stdio.h>

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define VX 21
#define VZ 21

#define STEPX 200.0
#define STEPZ 200.0

#define OX -2000.0
#define OY     0.0
#define OZ -2000.0

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

main()
{
 int i,j;

 printf("AMBIENT 0.2 0.2 0.2\n");
 printf("DIFFUSE  0.0 0.9 0.0\n");
 printf("SPECULAR 0.0 0.9 0.0\n");
 printf("SHININESS 128\n");

 printf("VERTICES %d\n",VX*VZ);

 for(i=0;i<VX;i++)
 {
  for(j=0;j<VZ;j++)
  {
   printf("%f %f %f\n",i*STEPX+OX,OY,j*STEPZ+OZ);
  }
 }

 printf("TRIANGLES %d\n",(VX-1)*(VZ-1)*2);
 for(i=0;i<VX-1;i++)
 {
  for(j=0;j<VZ-1;j++)
  {
   printf("%d %d %d\n",i*VZ+j+1, (i+1)*VZ+j,   i*VZ+j);
   printf("%d %d %d\n",i*VZ+j+1, (i+1)*VZ+j+1, (i+1)*VZ+j);
  }
 }
}

/**********************************************************/
