#ifndef _SDSL_WORLD_H_
#define _SDSL_WORLD_H_

/**********************************************************\
 * (SDSL2) Small Dynamic Shadows Library.                 *
 *                                                        *
 * Scene manager.                                         *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <windows.h>
#include <gl/gl.h>                          /* GLfloat */
#include <stdio.h>                          /* FILE */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * Camera.                                                *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Camera
{
 GLfloat position[4];                       /* in the world */
 GLfloat orientation[3];                    /* 3 angles */

 GLfloat fovY;                              /* field of view for Y */
 int sizeX,sizeY;                           /* viewport size */
 GLfloat nearZ,farZ;                        /* expected z range */
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

void cameraSetViewport(struct Camera* pCamera, int sx, int sy);
void cameraAdvance(struct Camera* pCamera, float distance);
void cameraRotate(struct Camera* pCamera, int axis, float distance);
void cameraEnable(struct Camera* camera);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * Lightsource.                                           *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define LIGHT_DRAW_DIAMETER 3.0
#define LIGHT_DRAW_SPLITS   16

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Light
{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];

 GLfloat position[4];                       /* a point light source */

 GLfloat constantAttenuation;               /* attenuation factors */
 GLfloat linearAttenuation;                 /* for proximity lights */
 GLfloat quadraticAttenuation;
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

extern struct Light* pCurrentLight;         /* light that was last enabled */
extern int nCurrentLight;                   /* at which position was it */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

void lightEnable(struct Light* pLight, int hwLightId );
void lightDraw(struct Light* pLight);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * Material -- entire model has one material.             *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Material
{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];
 GLfloat shininess;
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Material* materialCreate(FILE* f);
void materialDestroy(struct Material* pMaterial);
void materialEnable(struct Material* pMaterial);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#endif
