#ifndef _SDSL_UTIL_H_
#define _SDSL_UTIL_H_

/**********************************************************\
 * (SDSL2) Small Dynamic Shadows Library.                 *
 *                                                        *
 * Vector utility functions.                              *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <windows.h>
#include <gl/gl.h>                          /* GLfloat */
#include <math.h>                           /* sqrt */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * Operations on vectors.                                 *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define X 0                                 /* accessing vector */
#define Y 1                                 /* components */
#define Z 2
#define W 3                                 /* for homogeneous ones */

#define R 0                                 /* color components */
#define G 1
#define B 2
#define A 3                                 /* alpha */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

GLfloat* vectorConstruct(GLfloat* vec, GLfloat* a, GLfloat* b);
GLfloat* vectorZero(GLfloat* v);
GLfloat* vectorCopy(GLfloat* res, GLfloat* arg);
GLfloat* vectorAdd(GLfloat* sum, GLfloat* a, GLfloat* b);
GLfloat* vectorSub(GLfloat* dif, GLfloat* a, GLfloat* b);
GLfloat* vectorScale(GLfloat* sv, GLfloat* v, GLfloat scl);
GLfloat vectorScalarProduct(GLfloat* a, GLfloat* b);
GLfloat* vectorCrossProduct(GLfloat* cross, GLfloat* a, GLfloat* b);
GLfloat vectorLength(GLfloat* a);
void vectorNormalize(GLfloat* norm);
GLfloat* vectorNormal(GLfloat* norm, GLfloat* a, GLfloat* b, GLfloat* c);
GLfloat* vectorNormalV(GLfloat* norm, GLfloat* u, GLfloat* v);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * Operations on matrices.                                *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

GLfloat* matrixMultiply(GLfloat result[4],GLfloat matrix[4][4],GLfloat column[4]);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * A plane - a point on the plane and a normal.           *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Plane
{
 GLfloat p[4];                              /* point on the plane */
 GLfloat n[4];                              /* normal to the plane */
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Plane* planeConstruct(struct Plane* plane, GLfloat* a, GLfloat* b, GLfloat* c);
struct Plane* planeAdvance(struct Plane* pResPlane, struct Plane* pPlane, GLfloat distance);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **\
 * A ray - a point with codirected vector.                *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Ray
{
 GLfloat p[4];                              /* ray's origin */
 GLfloat v[4];                              /* codirected vector */
};

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

struct Ray* rayConstruct(struct Ray* ray, GLfloat* a, GLfloat* b);
GLfloat* rayPointOn(GLfloat* point, struct Ray* ray, GLfloat t);
GLfloat rayIntersectPlane(struct Ray* ray, struct Plane* plane);

/**********************************************************/

#endif
