#ifndef _SDSL_SHMAP_H_
#define _SDSL_SHMAP_H_

/**********************************************************\
 * (SDSL2) Small Dynamic Shadows Library.                 *
 *                                                        *
 * Drawing of shadow maps.                                *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <windows.h>
#include <gl/gl.h>                          /* GLfloat */
#include <gl/glu.h>                         /* gluPerspective */

#include "dslmodel.h"                       /* struct Model */
#include "dslworld.h"                       /* struct Light */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define SHADOW_MAP_NEAR_Z 1.0
#define SHADOW_MAP_FAR_Z  2000.0

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

void shadowMapDrawMap(struct ModelInstance** pModelInstances, int nModelInstances, GLfloat* lightPosition, GLfloat* mapCenter, GLfloat mapFovy);
void shadowMapDrawScene(struct ModelInstance** pModelInstances, int nModelInstances);

/**********************************************************/

#endif
