#ifndef _SDSL_PROJ_H_
#define _SDSL_PROJ_H_

/**********************************************************\
 * (SDSL2) Small Dynamic Shadows Library.                 *
 *                                                        *
 * Drawing of projective textures.                        *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <windows.h>
#include <gl/gl.h>                          /* GLfloat */
#include <gl/glu.h>                         /* gluPerspective */

#include "dslmodel.h"                       /* struct Model */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define PROJECTIVE_TEXTURE_NEAR_Z 1.0
#define PROJECTIVE_TEXTURE_FAR_Z  2000.0

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

void projectiveTextureDrawCaster(struct ModelInstance* pModelInstance, GLfloat* lightPosition);
void projectiveTextureDrawScene(struct ModelInstance** pModelInstances, int nModelInstances, GLfloat* lightPosition);

/**********************************************************/

#endif
