#ifndef _SDSL_OFSCR_H_
#define _SDSL_OFSCR_H_

/**********************************************************\
 * (SDSL2) Small Dynamic Shadows Library.                 *
 *                                                        *
 * Offscreen drawing.                                     *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <windows.h>
#include <gl/gl.h>                          /* GLfloat */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#define OFFSCREEN_BLACK 0                   /* clear offscreen to */
#define OFFSCREEN_WHITE 1

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

extern int offscreenSizeX;                  /* size of offscreen */
extern int offscreenSizeY;

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

void offscreenInit(int sizeX,int sizeY);
void offscreenDeinit(void);

void offscreenBegin(int clearColor, int makeBoarder);
void offscreenEnd(void);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

#endif
