/**********************************************************\
 * (SDSL2) Small Dynamic Shadows Library.                 *
 *                                                        *
 * Offscreen drawing.                                     *
 *                                                        *
 * Sergei Savchenko 2001.                                 *
\**********************************************************/

#include <stdlib.h>                         /* malloc */
#include "dslofscr.h"

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * **/

int offscreenTexture;                       /* texture id */
int offscreenSizeX;                         /* size of offscreen */
int offscreenSizeY;

/**********************************************************\
 * Initialize the module (allocate a texture).            *
\**********************************************************/

void offscreenInit(int sizeX, int sizeY)
{
 offscreenSizeX=sizeX;                      /* size of ofscreen texture */
 offscreenSizeY=sizeY;

 glGenTextures(1,&offscreenTexture);        /* assign id to texture */

 glTexEnvi(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
 glBindTexture(GL_TEXTURE_2D, offscreenTexture);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
 glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
 glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
}

/**********************************************************\
 * Deinitialize the module (destroy a texture).
\**********************************************************/

void offscreenDeinit(void)
{
 glDeleteTextures(1,&offscreenTexture);
}

/**********************************************************\
 * Start drawing to offscrrn (e.g.: set viewport).        *
\**********************************************************/

void offscreenBegin(int clearColor, int makeBoarder)
{
 glViewport(0, 0, offscreenSizeX, offscreenSizeY);

 switch(clearColor)
 {
  case OFFSCREEN_BLACK: glClearColor(0.0f, 0.0f, 0.0f, 1.0f ); break;
  case OFFSCREEN_WHITE: glClearColor(1.0f, 1.0f, 1.0f, 1.0f ); break;
 }
 glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

 if(makeBoarder) glViewport(1, 1, offscreenSizeX-2, offscreenSizeY-2);
}

/**********************************************************\
 * Finish drawing (transfer pixels back).                 *
\**********************************************************/

void offscreenEnd(void)
{
 glBindTexture(GL_TEXTURE_2D, offscreenTexture);
 glCopyTexImage2D(GL_TEXTURE_2D,0,GL_RGB8,0,0,offscreenSizeX,offscreenSizeY,0);
 glViewport(0, 0, offscreenSizeX, offscreenSizeY);
 glClearColor(0.0f, 0.0f, 0.0f, 1.0f );
}

/**********************************************************/
