
#include <Wire.h>
#include "BMP085.h"
#include "I2Cdev.h"
#include "MPU6050.h"
BMP085 pressure_m;
MPU6050 accelgyro;
int16_t ax, ay, az;
int16_t gx, gy, gz;
#define LED_PIN 13
bool blinkState = false;
void setup(){
  Serial.begin(9600);
  Wire.begin();
  //Serial.println("Initializing I2C devices...");
    accelgyro.initialize();

    // verify connection
    // Serial.println("Testing device connections...");
    // Serial.println(accelgyro.testConnection() ? "MPU6050 connection successful" : "MPU6050 connection failed");

    Serial.println("TempC,PressurePa,AltM,ax,ay,az,gx,gy,gz");
    // configure Arduino LED for
    pinMode(LED_PIN, OUTPUT);
  pressure_m.bmp085Calibration();
}

void loop()
{
  float temperature = pressure_m.bmp085GetTemperature(); //MUST be called first
  float pressure = pressure_m.bmp085GetPressure();
  float altitude = pressure_m.calcAltitude(pressure);

  //Serial.print("Temperature: ");
  Serial.print(temperature, 2); //display 2 decimal places
  Serial.print(",");
  //Serial.println("deg C");

  //Serial.print("Pressure: ");
  Serial.print(pressure, 0); //whole number only.
  Serial.print(",");
  //Serial.println(" Pa");

  //Serial.print("Altitude: ");
  Serial.print(altitude, 2); //display 2 decimal places
  Serial.print(",");
  //Serial.println(" M");

  //Serial.println();//line break

  delay(1000); //wait a second and get values again.
  accelgyro.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);

    // these methods (and a few others) are also available
    //accelgyro.getAcceleration(&ax, &ay, &az);
    //accelgyro.getRotation(&gx, &gy, &gz);

    // display tab-separated accel/gyro x/y/z values
    //Serial.print("a/g:\t");
    Serial.print(ax); Serial.print(","); // Serial.print("\t");
    Serial.print(ay); Serial.print(",");
    Serial.print(az); Serial.print(",");
    Serial.print(gx); Serial.print(",");
    Serial.print(gy); Serial.print(",");
    Serial.println(gz);

    // blink LED to indicate activity
    blinkState = !blinkState;
    digitalWrite(LED_PIN, blinkState);
}
